<?php


#echo "logging";

add_action( 'init', 'wpnuf_register_limit_log_table', 1 );
add_action( 'switch_blog', 'wpnuf_register_limit_log_table' );
 
function wpnuf_register_limit_log_table() {
    global $wpdb;
    $wpdb->limit_login_log = "{$wpdb->prefix}limit_login_log";
	#echo "reglog";
	#wpnuf_create_tables();

	#wpnuf_log_failed_login();
}

function wpnuf_create_tables() {
    // Code for creating a table goes here
	#echo "create_table";
require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
global $wpdb;
global $charset_collate;
// Call this manually as we may have missed the init hook
wpnuf_register_limit_log_table();

$sql_create_table = "CREATE TABLE {$wpdb->limit_login_log} (
          log_id bigint(20) unsigned NOT NULL auto_increment,
          username varchar(20)  NOT NULL default 'n/a',
          ip_address varchar(20) NOT NULL default '0.0.0.0',
          failed_attempts bigint(20) unsigned NOT NULL default '0',
          lockout_period bigint(20) unsigned NOT NULL default '0',
          full_lock tinyint  NOT NULL default '0',
          record_date datetime NOT NULL default '0000-00-00 00:00:00',
          PRIMARY KEY  (log_id),
          KEY username (username)
     ) $charset_collate; ";
 
 #echo $sql_create_table;
dbDelta( $sql_create_table );
}
 
// Create tables on plugin activation
register_activation_hook( __FILE__, 'wpnuf_create_tables' );

function wpnuf_log_failed_login( $name, $ip, $failures='0', $lockout='0', $long_lock=true) {
  global $wpdb;
   $username = ($name!='' ? $name : 'n/a') ;
   $ip_address = ($ip!='' ? $ip : '0.0.0.0');
   $failed_attempts = $failures;
   $lockout_period = $lockout;
   $longLock = ($long_lock ? '1': '0' );


   $table_name = $wpdb->limit_login_log;

   $rows_affected = $wpdb->insert( $table_name, array( 'record_date' => current_time('mysql'), 'username' => $username, 'ip_address' => $ip_address, 'failed_attempts' => $failed_attempts, 'lockout_period' => $lockout_period, 'full_lock' => $longLock ) );

   echo $rows_affected ;
}

?>