<?php
/**
 * @package NuFSMTP
 */
/*
Plugin Name: NufSmtp
Plugin URI: http://www.nufocus.co.uk/plugins/nufsmtp/?return=true
Description: NuFocus SMTP Plugin 
Version: 1.10.0
Author: David Coates
Author URI: http://www.nufocus.co.uk/
License: GPLv2 or later
*/

/*
This program is not free software; you can only use this plugin with written permission for the copyright owner.
*/

/*********************************************
* Define constants
*********************************************/

define('NUFSMTP_PLUGIN_URL', plugin_dir_url( __FILE__ ));

/*********************************************
* global
*********************************************/

$hman_prefix = 'nsmtp_';
$hman_plugin_name = 'Nuf SMTP Plugin';
// retrieve our plugin settings from the options table
global $nsmtp_options;
$nsmtp_options = get_option('nsmtp_settings');

global $nsmtp_db_tables;
$nsmtp_db_tables = array( 'diagnostic' => 'smtp_diagnostics',
						);

global $nsmtp_message_id;

define ('NSMTP_LOGFILE', 'maillog.txt');

if (file_exists(dirname(__FILE__) . "/nuf_plugin_updater.php")) {
	require_once(dirname(__FILE__) . "/nuf_plugin_updater.php");
}

add_action('wp_loaded', 'nsmtp_check_maillog');
function nsmtp_check_maillog() {
	global $nsmtp_options;

	$threshold = !empty($nsmtp_options['max_log_file_size']) ? $nsmtp_options['max_log_file_size'] : -1;


	if (file_exists(dirname(__FILE__) . "/" . NSMTP_LOGFILE)) {
		$line_count = nsmtp_get_log_line_count( dirname(__FILE__) . "/" . NSMTP_LOGFILE );

		if ($line_count>$threshold && $threshold!=-1) {
			echo "<br>Deleting Mail Log File - Line count=" . $line_count;
			chmod(dirname(__FILE__) . "/" . NSMTP_LOGFILE, 0777);
			unlink(dirname(__FILE__) . "/" . NSMTP_LOGFILE);
		}
	}
} # end of nsmtp_check_maillog

add_action( 'phpmailer_init', 'nsmtp_phpmailer_init' );
function nsmtp_phpmailer_init(  $phpmailer ) {
	global $nsmtp_options;
	global $nsmtp_message_id;

	$nsmtp_message_id = nsmtp_randomNumber(8);

	if (!is_array($nsmtp_options)) {
		return false;
	}
	if (isset($nsmtp_options['smtp_enabled']) && $nsmtp_options['smtp_enabled']) {

		if (!empty($nsmtp_options['smtp_logging'])) {
$phpmailer->Debugoutput = function ($str, $level) {

#	print_r($this);
#  file_put_contents(
#    dirname(__FILE__) . "/" . NSMTP_LOGFILE, #'/path/to/log/file',
#    date('Y-m-d H:i:s') . "\t" . $str,
#    FILE_APPEND | LOCK_EX
#  );
  global $nsmtp_message_id;
  do_action('nsmtp_message_log', $str, $level, $nsmtp_message_id );
};
		}

		if (!empty($nsmtp_options['smtp_loglevel']) && is_numeric($nsmtp_options['smtp_loglevel']) && !empty($nsmtp_options['smtp_logging'])) {
			$phpmailer->SMTPDebug = $nsmtp_options['smtp_loglevel'];
		}

		if (isset($nsmtp_options['smtp_host'])) {
			$phpmailer->Host = $nsmtp_options['smtp_host'];
		}
 		if (isset($nsmtp_options['smtp_port'])) {
			$phpmailer->Port = $nsmtp_options['smtp_port']; // could be different
		}
		if (isset($nsmtp_options['smtp_user'])) {
			$phpmailer->Username = $nsmtp_options['smtp_user']; // if required
		}
		if (!empty($nsmtp_options['smtp_sender'])) {
			// this sets the return path for error/bounce backs
			$phpmailer->Sender = $nsmtp_options['smtp_sender']; // if required
		}
		if (!empty($nsmtp_options['smtp_replyto'])) {
			// this sets a reply to if the send from is not the mailbox to respond to
			$phpmailer->addReplyTo($nsmtp_options['smtp_replyto']); // if required
		}

		if (isset($nsmtp_options['smtp_pass'])) {
			$phpmailer->Password = $nsmtp_options['smtp_pass']; // if required
		}
		if (isset($nsmtp_options['smtp_auth'])) {
		    $phpmailer->SMTPAuth = isset($nsmtp_options['smtp_auth']) ? $nsmtp_options['smtp_auth'] : false ; // if required
			if (isset($nsmtp_options['smtp_secure_protocol'])) {
				if ($nsmtp_options['smtp_secure_protocol']=='none'){ 
					$phpmailer->SMTPSecure = '';
				} else {
					$phpmailer->SMTPSecure = $nsmtp_options['smtp_secure_protocol']; // if required
				}
			}
		} else {
			$phpmailer->SMTPSecure = '';
		}

	// $phpmailer->SMTPSecure = 'ssl'; // enable if required, 'tls' is another possible value

#$phpmailer->SMTPDebug = 4;
           // Send the test mail
			if (isset($_POST['nsmtp_mail_debug']) && $_POST['nsmtp_mail_debug'] == 'Test' && isset($_POST['to']) && is_email($_POST['to'])) {
				#$phpmailer->SMTPDebug = 4;
			}

		$phpmailer->IsSMTP();

		#print_r($phpmailer);
		#die();
	} // smtp enabled 

}


// Function to change email address

function wpb_sender_email( $original_email_address ) {
	global $nsmtp_options;
#	print_r($nsmtp_options);
#	die;
	if (isset($nsmtp_options['wp_sender_email']) && $nsmtp_options['wp_sender_email']!='' ) {
		return $nsmtp_options['wp_sender_email'];
	}
	return $original_email_address;

}

// Function to change sender name
function wpb_sender_name( $original_email_from ) {
	global $nsmtp_options;
	#print_r($nsmtp_options);
	#die;
	if (isset($nsmtp_options['wp_sender_name']) && $nsmtp_options['wp_sender_name']!='') {
		return $nsmtp_options['wp_sender_name'];
	}
	return $original_email_from;
}

// Hooking up our functions to WordPress filters 
add_filter( 'wp_mail_from', 'wpb_sender_email', 20 );
add_filter( 'wp_mail_from_name', 'wpb_sender_name', 20 );


function nsmtp_get_log_line_count( $loc ) { 
	if (!file_exists($loc)) {
		return false;
	}

	$f = fopen($loc,'r');
	$count = 0;

	if (is_resource($f)) {
		while (fgets($f)) $count++;

		fclose($f);
	}

	return $count;
}




/*************************************
* Admin Page
*************************************/

function nsmtp_options_page() {
 
	global $nsmtp_options;
	global $phpmailer;


	// delete the log file?
	if (!empty($_POST['smtp_delete_log']) && isset($_POST['nsmtp_delete_log']) && $_POST['nsmtp_delete_log']=='1') {
		// delete the database table
		nsmtp_delete_log();

		// also delete physical file if it exists
		if (file_exists(dirname(__FILE__) . "/" . NSMTP_LOGFILE)) {
			chmod(dirname(__FILE__) . "/" . NSMTP_LOGFILE, 0777);
			unlink(dirname(__FILE__) . "/" . NSMTP_LOGFILE);
		}
	}
	// Send test email if requested
    if (isset($_POST['smtp_test']) && $_POST['smtp_test'] == 'Send' && (!isset($_POST['to']) || $_POST['to']=='') ) {
		?>
                <div id="message" class="error">
                <p><strong><?php _e('Send Error', 'nsmtp_domain' ); ?></strong></p>
                <p><?php _e('There was no recipient specified for the test email.', 'nsmtp_domain' ); ?></p>
                </div>
		<?php
	}
    elseif (isset($_POST['smtp_test']) && $_POST['smtp_test'] == 'Send' && isset($_POST['to']) && !is_email($_POST['to'])) {
		?>
                <div id="message" class="error">
                <p><strong><?php _e('Send Error', 'nsmtp_domain' ); ?></strong></p>
                <p><?php _e('The email address is not valid.', 'nsmtp_domain' ); ?></p>
                </div>
		<?php
	}
    if (isset($_POST['smtp_test']) && $_POST['smtp_test'] == 'Send' && isset($_POST['to']) && is_email($_POST['to'])) {
            
            $to = $_POST['to'];
            $subject = __( 'SMTP Test', 'nsmtp_domain' );
            $message = __( 'If you received this email it means you have configured SMTP correctly on your Wordpress website.', 'nsmtp_domain' );
    

			ob_start();	
			$diagnostic = '';
			// buffer the output in case we have enabled diagnostic debugs
		   // Send the test mail
			if (isset($_POST['nsmtp_mail_debug']) && $_POST['nsmtp_mail_debug'] == 'Test' && isset($_POST['to']) && is_email($_POST['to'])) {

			// (Re)create it, if it's gone missing
				if ( ! ( $phpmailer instanceof PHPMailer ) ) {
					require_once ABSPATH . WPINC . '/class-phpmailer.php';
					require_once ABSPATH . WPINC . '/class-smtp.php';
					$phpmailer = new PHPMailer( true );
				#echo "creating " . dirname(__FILE__) . '/maillog.txt';

	global $nsmtp_message_id;

	$nsmtp_message_id = nsmtp_randomNumber(8);

$phpmailer->Debugoutput = function ($str, $level) {
 # file_put_contents(
 #   dirname(__FILE__) . '/maillog.txt', #'/path/to/log/file',
  #  date('Y-m-d H:i:s') . "\t" . $str,
  #  FILE_APPEND | LOCK_EX
 # );
  global $nsmtp_message_id;
  do_action('nsmtp_message_log', $str, $level, $nsmtp_message_id );

};

				}
				$phpmailer->SMTPDebug = 4;
				echo "<pre>";
				print_r($phpmailer);
				echo "</pre>";
			}

            $result = wp_mail($to, $subject, $message);
			
			$diagnostic = ob_get_clean();

			if (isset($_POST['nsmtp_diagnostic']) && $_POST['nsmtp_diagnostic'] == 'Test' && isset($_POST['to']) && is_email($_POST['to'])) {
				ob_start();
				echo "<pre>";
				#echo $phpmailer->GetSentMIMEMessage();
				print_r($phpmailer);
				echo "</pre>";
				#$diagnostic = ob_get_contents()  . $diagnostic;
				ob_end_clean();
			}

			// Notify user of the result
            if ($result) {
                ?>
                <div id="message" class="updated fade">
                <p><strong><?php _e( 'Test Email Sent', 'nsmtp_domain' ); ?></strong></p>
                <p><?php _e('The test email was sent successfully!', 'nsmtp_domain' ); ?></p>
                </div>
                <?php
            }
            else {
                ?>
                <div id="message" class="error">
                <p><strong><?php _e('Send Error', 'nsmtp_domain' ); ?></strong></p>
                <p><?php _e('There was an error while trying to send the test email. Please check the connection details.', 'nsmtp_domain' ); ?></p>
                </div>
                <?php
            }    
    }

	$line_count = nsmtp_get_log_line_count( dirname(__FILE__) . "/" . NSMTP_LOGFILE );

	if (!is_array($nsmtp_options)) {
		$nsmtp_options = array();
	}
	if (!array_key_exists('smtp_secure_protocol', $nsmtp_options)) {
		$nsmtp_options['smtp_secure_protocol'] = '';
	}

 
	ob_start(); ?>
	<style>
	#smtp_options_table {
		max-width:100%;
	}
	#smtp_options_table td {
		vertical-align:top;
	}
	.smtp_label_col {
		min-width:220px;
		max-width:50%;
	}
	.smtp_inner_wrap {
		max-width:100%;
		overflow:auto;
	}

	</style>
	<div class="wrap">
		<div class="smtp_inner_wrap">
		<h2>NuFocus SMTP Plugin Options</h2>
 
		<form method="post" action="options.php">
 
			<?php settings_fields('nsmtp_settings_group'); ?>

			 
			<h4><?php _e('WordPress Email & SMTP Settings', 'nsmtp_domain'); ?></h4>

			<table width="50%" cellpadding="5" cellspacing="0" border="0" id="smtp_options_table">

			<tr><td class="smtp_label_col"><strong><span>Wordpress Sender Name&nbsp;</span></strong></td><td><input id="nsmtp_settings[wp_sender_name]" type="textbox" name="nsmtp_settings[wp_sender_name]" size="40" value="<?php echo !empty($nsmtp_options['wp_sender_name']) ? $nsmtp_options['wp_sender_name'] : ''; ?>" /> <br><span style="color:grey;">This will override the default sender name 'WordPress' for all sent emails. Recommend you use the domain or business name.</span></td></tr>


			<tr><td><strong><span>Wordpress Sender Email&nbsp;</span></strong></td><td><input id="nsmtp_settings[wp_sender_email]" type="textbox" name="nsmtp_settings[wp_sender_email]" size="40" value="<?php echo !empty($nsmtp_options['wp_sender_email']) ? $nsmtp_options['wp_sender_email'] : ''; ?>" /> <br><span style="color:grey;">This will override the default email (wordpress@domainname) for all outgoing emails. Ideally you should use a valid authenticated email address and send via SMTP using settings below.</span></td></tr>


			<tr><td><strong><span>Reply-To (optional)&nbsp;</span></strong></td><td><input id="nsmtp_settings[smtp_replyto]" type="textbox" name="nsmtp_settings[smtp_replyto]" size="40" value="<?php echo !empty($nsmtp_options['smtp_replyto']) ? $nsmtp_options['smtp_replyto'] : ''; ?>" /> <br><span style="color:grey;">This will set the reply-to field if you need to redirect responses to a specific email address.<br>(e.g. Use if sender address is only a generic mailer and not a monitored inbox)</span></td></tr>


			<tr><td colspan="2"><p style="color:red;">All other settings below are ignored unless the SMTP checkbox has been ticked.</p></td></tr>

			<tr><td><strong><?php _e('Enable SMTP Mode', 'nsmtp_domain'); ?></strong></td><td class="nsmtp_mandatory"><input id="nsmtp_settings[smtp_enabled]" type="checkbox" name="nsmtp_settings[smtp_enabled]" value="1" <?php checked("1",  (!empty($nsmtp_options['smtp_enabled']) ? 1 : 0 ) ) ?> /></td></tr>
			<tr><td><strong><span>SMTP Server&nbsp;</span></strong></td><td class="nsmtp_mandatory"><input id="nsmtp_settings[smtp_host]" type="textbox" name="nsmtp_settings[smtp_host]" size="40" value="<?php echo !empty($nsmtp_options['smtp_host']) ? $nsmtp_options['smtp_host'] : ''; ?>" /> <br><span style="color:red;">The servername must match exactly the CN name on the mail server certificate if TLS/SSL is selected as the secure protocol below</span></td></tr>
			<tr><td><span>SMTP Port&nbsp;(default is port 25)</span></td><td class="nsmtp_mandatory"><input id="nsmtp_settings[smtp_port]" type="textbox" name="nsmtp_settings[smtp_port]"  size="4" value="<?php echo !empty($nsmtp_options['smtp_port']) ? $nsmtp_options['smtp_port'] : ''; ?>"  /> (Typical ports used are: 25, 465 or 587)</td></tr>
			<tr><td><span>Sender&nbsp;(overrides the default reply to)<br>Error messages will be sent here</span></td><td><input id="nsmtp_settings[smtp_sender]" type="textbox" name="nsmtp_settings[smtp_sender]"  size="30" value="<?php echo !empty($nsmtp_options['smtp_sender']) ? $nsmtp_options['smtp_sender'] : ''; ?>"  /></td></tr>
			<tr><td><span>Username&nbsp;</span></td><td><input id="nsmtp_settings[smtp_user]" type="textbox" name="nsmtp_settings[smtp_user]"  size="30" value="<?php echo !empty($nsmtp_options['smtp_user']) ? $nsmtp_options['smtp_user'] : ''; ?>"  /></td></tr>
			<tr><td><span>Password&nbsp;</span></td><td><input id="nsmtp_settings[smtp_pass]" type="password" name="nsmtp_settings[smtp_pass]"  size="30" value="<?php echo !empty($nsmtp_options['smtp_pass']) ? $nsmtp_options['smtp_pass'] : ''; ?>"  /></td></tr>
			<tr><td><?php _e('SMTP Auth', 'nsmtp_domain'); ?></td><td><input id="nsmtp_settings[smtp_auth]" type="checkbox" name="nsmtp_settings[smtp_auth]" value="1" <?php checked("1", !empty($nsmtp_options['smtp_auth']) ? 1 : 0 ) ?> /></td></tr>
			<tr><td><span>Secure Protocol&nbsp;<br>(only used if SMTP Auth is enabled)</span></td><td><select id="nsmtp_settings[smtp_secure_protocol]" name="nsmtp_settings[smtp_secure_protocol]"><option <?= $nsmtp_options['smtp_secure_protocol']=='ssl' ? ' selected ' : ''?> value="ssl">SSL</option><option class="level-0" <?= $nsmtp_options['smtp_secure_protocol']=='tls' ? ' selected ' : ''?>  value="tls">TLS</option><option class="level-0" <?= $nsmtp_options['smtp_secure_protocol']=='none' ? ' selected ' : ''?>  value="none">None</option></select></td></tr>

			<tr><td><?php _e('Enable Logging', 'nsmtp_domain'); ?></td><td><input id="nsmtp_settings[smtp_logging]" type="checkbox" name="nsmtp_settings[smtp_logging]" value="1" <?php checked("1", !empty($nsmtp_options['smtp_logging']) ? 1 : 0) ?> /></td></tr>
			<tr><td><span>Logging Level&nbsp;(maximum of 4)</span></td><td><input id="nsmtp_settings[smtp_loglevel]" type="textbox" size=4 name="nsmtp_settings[smtp_loglevel]"  size="30" value="<?php echo !empty($nsmtp_options['smtp_loglevel']) ? $nsmtp_options['smtp_loglevel'] : ''; ?>"  /></td></tr>
			<tr><td><span>Max Log File Line count</span></td><td><input id="nsmtp_settings[max_log_file_size]" type="textbox" size=6 name="nsmtp_settings[max_log_file_size]"  size="30" value="<?php echo !empty($nsmtp_options['max_log_file_size']) ? $nsmtp_options['max_log_file_size'] : ''; ?>"  /></td></tr>

			</table>


			<p class="submit">
				<input type="submit" class="button-primary" value="<?php _e('Save Options', 'nsmtp_domain'); ?>" />
			</p>
 
		</form>

        <h3><?php _e('Send a Test Email', 'nsmtp_domain' ); ?></h3>
        <p><?php _e('Enter an email address below to send a test message.', 'nsmtp_domain' ); ?></p>
        <form action="options-general.php?page=nsmtp-options" method="post">
            <table class="optiontable form-table">
                <tr valign="top">
                    <td scope="row"><strong><label for="to"><?php _e('To:', 'nsmtp_domain' ); ?></label></strong></td>
                    <td  class="nsmtp_mandatory"><input name="to" type="text" id="to" value="" class="regular-text" />
                    </td>
                </tr>
   			<tr><td><?php _e('Diagnose Test Email', 'nsmtp_domain'); ?></td><td><input id="nsmtp_diagnostic" type="checkbox" name="nsmtp_diagnostic" value="Test"  />  (default is not ticked)</td></tr>
   			<tr><td><?php _e('Force PHPMailer Debug', 'nsmtp_domain'); ?></td><td><input id="nsmtp_mail_debug" type="checkbox" name="nsmtp_mail_debug" value="Test"  />  (default is not ticked)</td></tr>
         </table>
 		<p><span style="color:red;">Ensure you have saved your settings before running a test email. The test only uses the 'Saved' settings so you cannot save and test in the same step.</span></p>
           <p class="submit">
                <input type="submit" name="smtp_test" id="smtp_test" class="button-primary" value="<?php _e('Send', 'nsmtp_domain' ); ?>" />
            </p>
        </form>

        <h3><?php _e('Log File', 'nsmtp_domain' ); ?></h3>
		<!--<div><a target="_blank" href="<?php echo plugin_dir_url(__FILE__). NSMTP_LOGFILE; ?>">View Log File</a>&nbsp;&nbsp;(Current Size:<?php echo $line_count; ?> lines)</div>-->
		<div><a target="_blank" href="<?php echo '/wp-admin/admin.php?page=nsmtp-show-log'; ?>">View SMTP Log</a>&nbsp;&nbsp;</div>
		<form action="options-general.php?page=nsmtp-options" method="post">
		<input type="hidden" name="nsmtp_delete_log" value="1">
           <p class="submit">
                <input type="submit" name="smtp_delete_log" id="smtp_delete_log" class="button-primary" value="<?php _e('Delete Log', 'nsmtp_domain' ); ?>" />
            </p>
		</form>

		</div>

	</div>
	<?php
	echo ob_get_clean();
	echo (isset($diagnostic) ? $diagnostic : '' );
}
function nsmtp_add_options_link() {
	add_options_page('NuF SMTP Plugin Options', 'Nuf SMTP Edit', 'manage_options', 'nsmtp-options', 'nsmtp_options_page');

    add_submenu_page(null, __('SMTP Log', 'NSMTP'),  __('SMTP Log', 'NSMTP') , 'manage_options', 'nsmtp-show-log', 'nsmtp_show_log');
    add_submenu_page(null, __('SMTP Message', 'NSMTP'),  __('SMTP Message', 'NSMTP') , 'manage_options', 'nsmtp-show-message', 'nsmtp_show_message');

}
add_action('admin_menu', 'nsmtp_add_options_link');

function nsmtp_register_settings() {
	// creates our settings in the options table
	register_setting('nsmtp_settings_group', 'nsmtp_settings');
}
add_action('admin_init', 'nsmtp_register_settings');




function nsmtp_purge_log() {
	global $wpdb;
	global $nsmtp_options;
    $tablename = $wpdb->prefix . $nsmtp_db_tables['diagnostic'];
    $sql = "TRUNCATE TABLE $tablename;";
	#echo $sql;
    $wpdb->query($sql);
	echo '<div style="margin-top:50px;color:red;font-size:110%;">The diagnostics records have been purged. <a href="/wp-admin/options-general.php?page=nsmtp_options">Click here</a> to return to the settings page.</div>';
}

function nsmtp_delete_log() {
	global $wpdb;
	global $nsmtp_options;
	global $nsmtp_db_tables;
    $tablename = $wpdb->prefix . $nsmtp_db_tables['diagnostic'];
    $sql = "DROP TABLE IF EXISTS $tablename;";
	#echo $sql;
    $wpdb->query($sql);
	echo '<div style="margin-top:50px;color:red;font-size:110%;">The diagnostics database table has been deleted. <a href="/wp-admin/options-general.php?page=nsmtp_options">Click here</a> to return to the settings page.</div>';
}

function nsmtp_download_log_record() {
	global $wpdb;
	global $nsmtp_options;
	global $nsmtp_db_tables;
    $tablename = $wpdb->prefix . $nsmtp_db_tables['diagnostic'];

	$sql = "select * from $tablename";
	$params = array();
	$prepared_query = $wpdb->prepare($sql, $params);
	$results = $wpdb->get_results( $prepared_query, ARRAY_A );

	echo "<h2>NSMTP log</h2>";
	echo "<pre>";
	if (!empty($results)) {
		foreach ($results as $row) {
			echo "<br>" . $row['id'] . ', '. $row['recordtime'] . ', ', $row['message'];
			#print_r(json_decode($row['message']));
		}
	}
	echo "</pre>";
}

function nsmtp_show_log() {
	global $wpdb;
	global $nsmtp_db_tables;
    $tablename = $wpdb->prefix . $nsmtp_db_tables['diagnostic'];

	echo "<h1>NuFocus SMTP Log</h1>";

	$sql = "select * from $tablename where level=1 and message LIKE '%RCPT%' ORDER BY id desc ";
	$params = array();
	$prepared_query = $wpdb->prepare($sql, $params);
	$results = $wpdb->get_results( $prepared_query, ARRAY_A );
#	$results = json_decode(json_encode($results), true);

#	print_r($results);
	echo '<table width="100%">';
		echo '<tr><th>Message</th><th>To</th><th>Time</th></tr>';
	foreach ($results as $row) {
		echo '<tr><td style="color:blue;"><a href="/wp-admin/admin.php?page=nsmtp-show-message&message_id='.$row['message_id'].'">'.$row['message_id'].'</a></td><td>'.htmlentities($row['message']).'</td><td style="color:red;">'.$row['recordtime'].'</td></tr>';

	}
	echo '</table>';
}

function nsmtp_show_message() {
	global $wpdb;
	global $nsmtp_db_tables;
    $tablename = $wpdb->prefix . $nsmtp_db_tables['diagnostic'];

	echo '<h1>SMTP Message</h1>';
?>
<style>
.level1.hideRow {
	display:none;
}
.level2.hideRow {
	display:none;
}
.level3.hideRow {
	display:none;
}
.level4.hideRow {
	display:none;
}
</style>
<?php
	$message_id = !empty($_GET['message_id']) ? $_GET['message_id'] : '';
	if (!empty($message_id)) {
	
		$params = array( $message_id );
		$sql = "select * from $tablename where message_id=%s ";
		$prepared_query = $wpdb->prepare($sql, $params);
		$results = $wpdb->get_results( $prepared_query, ARRAY_A );
	#	$results = json_decode(json_encode($results), true);

		echo '<div id="levelChecks" style="display:flex;justify-content:space-between;width:50%;">
		<div><span>Level 1</span>&nbsp;<input type="checkbox" value="on" name="" id="level_1" checked="checked"></div>
		<div><span>Level 2</span>&nbsp;<input type="checkbox" value="on" name="" id="level_2" checked="checked"></div>
		<div><span>Level 3</span>&nbsp;<input type="checkbox" value="on" name="" id="level_3" checked="checked"></div>
		<div><span>Level 4</span>&nbsp;<input type="checkbox" value="on" name="" id="level_4" checked="checked"></div>
		</div>';
	#	print_r($results);
		#echo '<table width="100%">';
		#echo '<tr><th>Message</th><th>To</th><th>Time</th></tr>';
		#foreach ($results as $row) {
		#	echo '<tr><td style="color:blue;">'.$row['message_id'].'</td><td>'.htmlentities($row['message']).'</td><td style="color:red;">'.$row['recordtime'].'</td></tr>';
		#}
		#echo '</table>';

		echo '<div style="display:grid; grid-gap:1em; grid-template-columns: 105px 40px 1fr 200px;">';
			echo '<div style="color:blue;">message_id</div><div style="color:blue;">level</div><div style="text-align:left;">message</div><div  style="color:red;min-width:200px;">recordtime</div>';
			foreach ($results as $row) {
				$levelClass = 'level' . $row['level'];
				echo '<div class="'.$levelClass.'" style="color:blue;">'.$row['message_id'].'</div><div class="'.$levelClass.'" style="color:blue;">'.$row['level'].'</div><div  class="'.$levelClass.'" style="text-align:left;">'.htmlentities($row['message']).'</div><div  class="'.$levelClass.'" style="color:red;min-width:200px;">'.$row['recordtime'].'</div>';
			}

		echo '</div>';
?>
<script>
		jQuery('#levelChecks input[type="checkbox"]').on("click", function() {
			var levelpart = jQuery(this).attr("id");
			var levels = levelpart.split('_');
			console.log(levelpart);
			var level = levels[1];
			for (i=1; i<5;i++ )
			{
				jQuery(".level" + i).removeClass("hideRow");
				if ((i-1)>=level)
				{
					jQuery(".level" + i).addClass("hideRow");
					jQuery("#level_" + i).prop("checked", false);
				} else {
					jQuery("#level_" + i).prop("checked", true);
				}

			}
			//	jQuery(this).is(':checked')
		});
</script>
<?php

	}

}

function nsmtp_plugin_create_db($table) {

	global $wpdb;
	$charset_collate = $wpdb->get_charset_collate();
	$table_name = $wpdb->prefix . $table;

	$sql = "CREATE TABLE $table_name (
		id bigint(11) NOT NULL AUTO_INCREMENT,
		message_id varchar(20) DEFAULT NULL,  
		message text DEFAULT NULL,
		level varchar(20) DEFAULT NULL,
		recordtime datetime DEFAULT current_timestamp() NOT NULL ON UPDATE current_timestamp(),
		UNIQUE KEY id (id)
	) $charset_collate;";

	require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
	dbDelta( $sql );
}

function nsmtp_table_exists( $table ) {
    global $wpdb;

 	$table_name = $wpdb->prefix . $table;

    $query = $wpdb->prepare( 'SHOW TABLES LIKE %s', $wpdb->esc_like( $table_name ) );
 
    if ( $wpdb->get_var( $query ) == $table_name ) {
        return true;
    }
 
    return false;
}

function nsmtp_randomNumber( $length='') {
	$str_length = 5;
	if (!empty($length) && is_numeric($length) && $length>1) {
		$str_length = $length-1;
	} 
	return substr(str_shuffle('123456789'),0, 1) . substr(str_shuffle('0123456789'),0, $str_length);
}



add_action('nsmtp_message_log', 'nsmtp_message_log', 10, 3);
function nsmtp_message_log( $str, $level, $message_id ) {
    global $wpdb;
	global $nsmtp_db_tables;

	$table = $nsmtp_db_tables['diagnostic'];

	if (!nsmtp_table_exists( $table )) {
		nsmtp_plugin_create_db( $table );
	}

	$tablename = $wpdb->prefix . $table;

	$data = array() ;
	$data['message_id'] = $message_id;
	$data['message']  = $str;
	$data['level']  = $level;

	$wpdb->insert($tablename, $data);
	return false;

}

?>