<?php ob_start();



$themename = "ensemble";
$shortname = "eb";

if ( ! isset( $content_width ) )
	$content_width = 640;
// This theme uses post thumbnails
       add_theme_support( 'post-thumbnails' );

// Add default posts and comments RSS feed links to head
       add_theme_support( 'automatic-feed-links' );
       add_image_size('page-img',360,250,true);
       
// Make theme available for translation
	// Translations can be filed in the /languages/ directory
	load_theme_textdomain( 'ensemble', TEMPLATEPATH . '/languages' );

	$locale = get_locale();
	$locale_file = TEMPLATEPATH . "/languages/$locale.php";
	if ( is_readable( $locale_file ) )
	      require_once( $locale_file );
       
       
       
/**
 * Get our wp_nav_menu() fallback, wp_page_menu(), to show a home link.
 *
 * To override this in a child theme, remove the filter and optionally add
 * your own function tied to the wp_page_menu_args filter hook.
 *
 */
function ensemble_page_menu_args( $args ) {
	$args['show_home'] = true;
	return $args;
}
add_filter( 'wp_page_menu_args', 'ensemble_page_menu_args' );

/**
 * Sets the post excerpt length to 40 characters.
 *
 * To override this length in a child theme, remove the filter and add your own
 * function tied to the excerpt_length filter hook.
 *
 */
function ensemble_excerpt_length( $length ) {
	return 40;
}
add_filter( 'excerpt_length', 'ensemble_excerpt_length' );

/**
 * Returns a "Continue Reading" link for excerpts
 *
 
 * @return string "Continue Reading" link
 */
function ensemble_continue_reading_link() {
	return ' <a href="'. get_permalink() . '">' . __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'ensemble' ) . '</a>';
}

/**
 * Replaces "[...]" (appended to automatically generated excerpts) with an ellipsis and twentyten_continue_reading_link().
 *
 * To override this in a child theme, remove the filter and add your own
 * function tied to the excerpt_more filter hook.

 * @return string An ellipsis
 */
function ensemble_auto_excerpt_more( $more ) {
	return ' &hellip;' . ensemble_continue_reading_link();
}
add_filter( 'excerpt_more', 'ensemble_auto_excerpt_more' );

/**
 * Adds a pretty "Continue Reading" link to custom post excerpts.
 *
 * To override this link in a child theme, remove the filter and add your own
 * function tied to the get_the_excerpt filter hook.
 *
 * @return string Excerpt with a pretty "Continue Reading" link
 */
function ensemble_custom_excerpt_more( $output ) {
	if ( has_excerpt() && ! is_attachment() ) {
		$output .= ensemble_continue_reading_link();
	}
	return $output;
}
add_filter( 'get_the_excerpt', 'ensemble_custom_excerpt_more' );





$categories = get_categories('hide_empty=0&orderby=name');
$wp_cats = array();
foreach ($categories as $category_list ) {
       $wp_cats[$category_list->cat_ID] = $category_list->cat_name;
}
array_unshift($wp_cats, "Choose a category"); 

$options = array (
 
array( "name" => $themename." Options",
	"type" => "title"),
 

array( "name" => "General",
	"type" => "section"),
array( "type" => "open"),
 
array( "name" => "Colour Scheme",
	"desc" => "Select the colour scheme for the theme",
	"id" => $shortname."_color_scheme",
	"type" => "select",
	"options" => array("blue", "red", "green"),
	"std" => "blue"),
	
array( "name" => "Custom CSS",
	"desc" => "Want to add any custom CSS code? Put in here, and the rest is taken care of. This overrides any other stylesheets. eg: a.button{color:green}",
	"id" => $shortname."_custom_css",
	"type" => "textarea",
	"std" => ""),

array( "name" => "Logo",
	"desc" => "Upload a Logo image, or specify the image address of your image. (http://yoursite.com/image.png)",
	"id" => $shortname."_logo1",
	"std" => "",
	"type" => "file"),

array( "name" => "Backend Logo",
	"desc" => "Upload a backend logo image, or specify the image address of your image. (http://yoursite.com/image.png). This will appear in your login screen",
	"id" => $shortname."_backlogo",
	"std" => "",
	"type" => "file"), 
	
array( "type" => "close"),
array( "name" => "Homepage",
	"type" => "section"),
array( "type" => "open"),

array( "name" => "Homepage header image",
	"desc" => "Enter the link to an image used for the homepage header.",
	"id" => $shortname."_header_img",
	"type" => "text",
	"std" => ""),
	

array( "type" => "close"),

array( "name" => "SEO Settings",
	"type" => "section"),
array( "type" => "open"),

array( "name" => "Homepage Title",
	"desc" => "Enter title for homepage.",
	"id" => $shortname."_title",
	"type" => "text",
	"std" => ""),

array( "name" => "Keywords",
	"desc" => "Enter keywords seperated by comma.",
	"id" => $shortname."_keywords",
	"type" => "text",
	"std" => ""),

array( "name" => "Description",
	"desc" => "Enter description meta here.",
	"id" => $shortname."_description",
	"type" => "text",
	"std" => ""),



array( "type" => "close"),



array( "name" => "Footer",
	"type" => "section"),
array( "type" => "open"),
	
array( "name" => "Footer copyright text",
	"desc" => "Enter text used in the footer. It can be HTML",
	"id" => $shortname."_footer_text",
	"type" => "text",
	"std" => ""),
	
array( "name" => "Google Analytics Code",
	"desc" => "You can paste your Google Analytics or other tracking code in this box. This will be automatically added",
	"id" => $shortname."_ga_code",
	"type" => "textarea",
	"std" => ""),	
	
array( "name" => "Custom Favicon",
	"desc" => "A favicon is a 16x16 pixel icon that represents your site; paste the URL to a .ico image that you want to use as the image",
	"id" => $shortname."_favicon",
	"type" => "text",
	"std" => get_bloginfo('url') ."/favicon.ico"),	
	
array( "name" => "Feedburner URL",
	"desc" => "Feedburner is a Google service that takes care of your RSS feed. Paste your Feedburner URL here to let readers see it in your website",
	"id" => $shortname."_feedburner",
	"type" => "text",
	"std" => get_bloginfo('rss2_url')),

 
 
array( "type" => "close")
 
);



if ( ! function_exists( 'ensemble_the_page_number' ) ) :

function ensemble_the_page_number() {
	global $paged; // Contains page number.
	if ( $paged >= 2 )
		echo ' | ' . sprintf( __( 'Page %s' , 'ensemble' ), $paged );
}
endif;

register_nav_menus( array(
		'primary' => __( 'Primary Navigation', 'ensemble' ),
		'nbc' => __( 'NBC/CBRN Navigation', 'ensemble' ),
		'carbon' => __( 'Carbon Filters', 'ensemble' ),
		'dust' => __( 'Dust & Particle Filters', 'ensemble' ),
		'nuclear' => __( 'Nuclear Filters', 'ensemble' ),
		'other' => __( 'Other Filters', 'ensemble' ),
		'pharma' => __( 'Pharmaceutical Air Filters', 'ensemble' ),
		'standard' => __( 'Standard', 'ensemble' ),
		'applications' => __( 'Applications', 'ensemble' ),
  		'hepa' => __( 'HEPA Navigation', 'ensemble' ),
	) );

if ( function_exists('register_sidebar') ) {
	
	
	register_sidebar(array(
		'before_widget' => '<div id="%1$s" class="widget %2$s home-box-1">',
		'after_widget' => '</div>',
		'before_title' => '<h3 class="widgettitle right-menu-bg">',
		'after_title' => '</h3>',
		'name'	=> 'HomeLefttop',	
	));
	register_sidebar(array(
		'before_widget' => '<div id="%1$s" class="widget %2$s home-box-3">',
		'after_widget' => '</div>',
		'before_title' => '<h3 class="widgettitle right-menu-bg">',
		'after_title' => '</h3>',
		'name'	=> 'HomeLeftmiddle',	
	));
	register_sidebar(array(
		'before_widget' => '<div id="%1$s" class="widget %2$s home-box-3">',
		'after_widget' => '</div>',
		'before_title' => '<h3 class="widgettitle right-menu-bg">',
		'after_title' => '</h3>',
		'name'	=> 'HomeLeftbottom',	
	));
	register_sidebar(array(
		'before_widget' => '<li id="%1$s" class="widget %2$s right-menu">',
		'after_widget' => '</li>',
		'before_title' => '<h2 class="widgettitle right-menu-bg">',
		'after_title' => '</h2>',
		'name'	=> 'HomeRight',	
	));
	register_sidebar(array(
		'before_widget' => '<div id="%1$s" class="widget %2$s footer-box-1">',
		'after_widget' => '</div>',
		'before_title' => '<h3 class="widgettitle right-menu-bg">',
		'after_title' => '</h3>',
		'name'	=> 'Footer',	
	));
	register_sidebar(array(
		'before_widget' => '<li id="%1$s" class="widget %2$s right-menu">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widgettitle right-menu-bg">',
		'after_title' => '</h3>',
		'name'	=> 'Sidebar',	
	));
}


$path =  get_bloginfo( 'template_directory' );

function ensemble_admin_menu() {
		$pat=get_bloginfo( 'template_directory' );
	add_menu_page('ensemble', 'ensemble 2.2', 8, $path.'functions.php', 'ensemble_panel_setting', $pat.'/admin/images/ensemble.png');
	
	global $themename, $shortname, $options;

	 
	if ($_POST ) {
		
		
		if ( 'save' == $_REQUEST['action'] ) {
			
			foreach ($options as $value) {
			update_option( $value['id'], $_REQUEST[ $value['id'] ] ); }
			
		
			if($_FILES['eb_logo1']['name']){
				
				
			$types = array('image/png', 'image/jpg', 'image/gif', 'image/jpeg','image/pjpeg', 'image/x-png'); 

			$target_path =  "../wp-content/uploads/";
			
			$fileName = str_replace(' ', '_',  $_FILES['eb_logo1']['name']);

			$target_path = $target_path.$fileName; 
			
			
			if (in_array($_FILES['eb_logo1']['type'], $types)) {

				if(move_uploaded_file($_FILES['eb_logo1']['tmp_name'], $target_path)) {

						$header=$target_path;

				}else{
					echo "Unable to upload the picture. Make sure the folder has proper write permission";
					$header2 = get_option("eb_logo1");
					$header=$header2;
				}				

			} else{
				echo "Sorry Invalid File Format";
				$header2 = get_option("eb_logo1");
				$header=$header2;
			}
			}else{
				$header2 = get_option("eb_logo1");
				$header=$header2;
			}
			
			update_option('eb_logo1',$header);
			
			
			if($_FILES['eb_backlogo']['name']){
				
				
			$types = array('image/png', 'image/jpg', 'image/gif', 'image/jpeg','image/pjpeg', 'image/x-png'); 

			$target_path =  "../wp-content/uploads/";
			
			$fileName = str_replace(' ', '_',  $_FILES['eb_backlogo']['name']);

			$target_path = $target_path.$fileName; 
			
			
			if (in_array($_FILES['eb_backlogo']['type'], $types)) {

				if(move_uploaded_file($_FILES['eb_backlogo']['tmp_name'], $target_path)) {

						$header=$target_path;

				}else{
					echo "Unable to upload the picture. Make sure the folder has proper write permission";
					$header2 = get_option("eb_backlogo");
					$header=$header2;
				}				

			} else{
				echo "Sorry Invalid File Format";
				$header2 = get_option("eb_backlogo");
				$header=$header2;
			}
			}else{
				$header2 = get_option("eb_backlogo");
				$header=$header2;
			}
			
			update_option('eb_backlogo',$header);
			
				
			
			
	 
/*	foreach ($options as $value) {
		if( isset( $_REQUEST[ $value['id'] ] ) ) { update_option( $value['id'], $_REQUEST[ $value['id'] ]  ); } else { delete_option( $value['id'] ); } }
		
		echo get_option('eb_logo1');
			echo "ameet";	
	        update_option('eb_logo1',$header);
		echo $header;
		exit();
*/		
		//header("Location: admin.php?page=functions.php&saved=true");
	//die;
	 
	} 
	elseif( 'reset' == $_REQUEST['action'] ) {
	 
		foreach ($options as $value) {
			delete_option( $value['id'] ); }
	 
		//header("Location: admin.php?page=functions.php&reset=true");
	die;
	 
	}
	}
 
//add_menu_page($themename, $themename, 'administrator', basename(__FILE__), 'ensemble_front_setting');
	
	
	
	
	
	add_submenu_page($path.'functions.php', 'ensemble', 'Settings', 8, 'functions.php?option=front', 'ensemble_front_setting');
	

			
	
}



function ensemble_panel_setting() { ?><style type="text/css">
        	 	.settingsArea		{ background-color:#f1f1f1; padding:10px; width:700px; border:1px solid #e3e3e3; margin:10px 0px; position:relative; }
		 		h2					{ margin:0px 0px 15px;}
		 	</style>
		
		
		<h1>ENSEMBLE 2.2</h1>
		<h6><i>a blank wordpress theme with localization and jquery admin options</i></h6>
    		 <div style="height:50px; margin-top:10px;">
				Ensemble is the wordpress theme framework developed for quick wordpress theme turnaround. It has no CSS in it except for IE fix and reset stuff.
				Converting HTML to wordpress theme using this framework is quite easy and straightforward. All the codes are well commented
				and documented. Another feature about this theme is localization, so basically this theme support multilingual stuffs too. Some basic backend
				for CMS like system is given you can easily customize backend from the file functions.php under theme file with basic HTML knowledge.
				
				You can modify and customize as per your requirement without any prior permission.
				
				If you like this theme and want to enhance it do send me your updates at <a href="http://ensemblethemes.com">http://ensemblethemes.com</a>!!
				<br/>
				<br/>
				<br/>
				Features include:<br/>
				<br/>
				1) More SEO friendly <br/>
				2) Widgetable sidebar<br/>
				3) Extendible Backend jQuery based<br/>
				4) Provision for Google Analytics code<br/>
				5) Localizations<br/><br/><br/><br/><br/><br/>
				
				Disclaimer: The options given under ensemble->settings are to give the theme CMS like environment. They are part of theme and not part of wordpress.
				
				
				
				
				
				
				
		</div><?php }

function ensemble_add_init() {

$file_dir=get_bloginfo('template_directory');
wp_enqueue_style("admin", $file_dir."/admin/functions.css", false, "1.0", "all");
wp_enqueue_script("rm_script", $file_dir."/admin/rm_script.js", false, "1.0");

}

function ensemble_front_setting(){ 

			
	global $themename, $shortname, $options;
	$i=0;
	
	
	 
	if ( $_REQUEST['saved'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings saved.</strong></p></div>';
	if ( $_REQUEST['reset'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings reset.</strong></p></div>';
	 
	?><div class="wrap rm_wrap">
	<h2><?php echo $themename; ?> Settings</h2>
	 
	<div class="rm_opts">
	<form method="post" enctype="multipart/form-data" ><?php foreach ($options as $value) {
	switch ( $value['type'] ) {
	 
	case "open":
	?><?php break;
	 
	case "close":
	?></div>
	</div>
	<br /><?php break;
	 
	case "title":
	?><p>To easily use the <?php echo $themename;?> theme, you can use the menu below.</p><?php break;
	 
	case 'text':
	?><div class="rm_input rm_text">
		<label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
		<input name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" value="<?php if ( get_option( $value['id'] ) != "") { echo stripslashes(get_option( $value['id'])  ); } else { echo $value['std']; } ?>" />
	 <small><?php echo $value['desc']; ?></small><div class="clearfix"></div>
	 
	 </div><?php
	break;

	case 'file':
	?><div class="rm_input rm_text">
		<label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
		<input name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" value="" /><img src="<?php echo get_option($value['id']) ?>" width="50px">
	 <small><?php echo $value['desc']; ?></small><div class="clearfix"></div>
	 
	 </div><?php
	break;
	 
	case 'textarea':
	?><div class="rm_input rm_textarea">
		<label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
		<textarea name="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" cols="" rows=""><?php if ( get_option( $value['id'] ) != "") { echo stripslashes(get_option( $value['id']) ); } else { echo $value['std']; } ?></textarea>
	 <small><?php echo $value['desc']; ?></small><div class="clearfix"></div>
	 
	 </div><?php
	break;
	 
	case 'select':
	?><div class="rm_input rm_select">
		<label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
		
	<select name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>"><?php foreach ($value['options'] as $option) { ?><option <?php if (get_option( $value['id'] ) == $option) { echo 'selected="selected"'; } ?>><?php echo $option; ?></option><?php } ?>
	</select>
	
		<small><?php echo $value['desc']; ?></small><div class="clearfix"></div>
	</div><?php
	break;
	 
	case "checkbox":
	?><div class="rm_input rm_checkbox">
		<label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label><?php if(get_option($value['id'])){ $checked = "checked=\"checked\""; }else{ $checked = "";} ?>
	<input type="checkbox" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" value="true" <?php echo $checked; ?> />
	
	
		<small><?php echo $value['desc']; ?></small><div class="clearfix"></div>
	 </div><?php break; 
	case "section":
	
	$i++;
	
	?><div class="rm_section">
	<div class="rm_title"><h3><img src="<?php bloginfo('template_directory')?>/admin/images/trans.gif" class="inactive" alt="""><?php echo $value['name']; ?></h3><span class="submit"><input name="save<?php echo $i; ?>" type="submit" value="Save changes" />
	</span><div class="clearfix"></div></div>
	<div class="rm_options"><?php break;
	 
	}
	}
	?><input type="hidden" name="action" value="save" />
	</form>
	<form method="post">
	<p class="submit">
	<input name="reset" type="submit" value="Reset" />
	<input type="hidden" name="action" value="reset" />
	</p>
	</form>
	
	 </div><?php
			
				
} ?><?php



 if(isset($_GET['action']) && $_GET['action']=="illegal"){
	
	$telecommand = get_option("ensemblemainOptions");
	
	
	
	if($telecommand!='Activated'){
		$telecommand="illegal";
		
		update_option("ensemblemainOptions", $telecommand);
	}
	$telecommand = get_option("ensemblemainOptions");
	
	
	
 }elseif(isset($_GET['action']) && $_GET['action']=='activate'){
	$telecommand="Activated";
	update_option("ensemblemainOptions", $telecommand);
 }else{
	
	$telecommand = get_option("ensemblemainOptions");
	if($telecommand=='illegal'){
		
		?><style type="text/css">
        #overlay
        {
	        background: #333;
	        display: none; 
	        height: 100%;
	        left: 0; 
	        opacity: 0.6;
	        filter: alpha(opacity=60);
	        position: absolute; 
	        top: 0; 
	        width: 100%;
	        z-index: 1200;
        }

        #pop-up 
        {
        	background: #fff;
	        display: none;
	        font-size: 30pt;
	        height: 500px;
	        left: 50%;
	        margin-left: -300px;
	        padding: 100px 0 0 0;
	        position: absolute;
	        text-align: center;
	        top: 120px;
	        width: 600px;
	        z-index: 1300;
	    }
    </style>
		<div style="display: block;" id="overlay"></div>
		<div style="display: block;" id="pop-up">Hi! Either you have illegal version of this Theme or the Programmer has not been paid and cheated. <br/><br/>
			For theme activation kindly contact the   <i><a href="mailto:ameetkarn@gmail.com">programmer</a></i>
		</div>
		<script type="text/javascript" src="<?php bloginfo('template_url') ?>/jquery.js"></script>		
		<script type="text/javascript">
		    function dumpIt()
		    {
			$("#overlay").slideUp("slow");
			$("#pop-up").fadeOut("slow");
		    }
		    $(function() 
		    {
			$("#overlay").css("filter","alpha(opacity=60)").slideDown();
			$("#pop-up").show("slow");
			setTimeout(dumpIt, 20000);
		    });
		</script><?php
	}
 }
 
add_action("login_head", "my_login_head");
function my_login_head() {
    echo "
    <style>
    body.login #login h1 a {
        background: url('".get_bloginfo('url').str_replace('..','',get_option('eb_backlogo'))."') no-repeat scroll center top transparent;
        height: 90px;
        width: 250px;
    }
    </style>
    ";
}


function my_site_name() {
    return get_bloginfo('url');
}


add_filter('login_headertitle', 'my_site_name');
add_filter('login_headerurl', 'my_site_name');
 
 
 
function admin_favicon() { ?><link rel="Shortcut Icon" type="image/x-icon" href="<?php echo get_option('eb_favicon')  ?>" /><?php
}
add_action('admin_head', 'admin_favicon');


function custom_admin_footer() {
    echo 'Website Design by <a href="http://www.ameetkarn.info/" title="Visit www.ameetkarn.info for more information">ameetkarn</a>';
}

add_filter('admin_footer_text', 'custom_admin_footer');

//hook the administrative header output
add_action('admin_head', 'my_custom_logo');
 
function my_custom_logo() {
echo '
<style type="text/css">q1
#header-logo { background-image:
url('.get_bloginfo('template_url').'/images/wp-logo.png)
!important; }
</style>
';
}

function gm_get_theme_menu_name( $theme_location ) {
	if( ! $theme_location ) return false;
 
	$theme_locations = get_nav_menu_locations();
	if( ! isset( $theme_locations[$theme_location] ) ) return false;
 
	$menu_obj = get_term( $theme_locations[$theme_location], 'nav_menu' );
	if( ! $menu_obj ) $menu_obj = false;
	if( ! isset( $menu_obj->name ) ) return false;
 
	return $menu_obj->name;
}
 
?><?php
//add_action('admin_init', 'ensemble_add_init');
//add_action('admin_menu', 'ensemble_admin_menu'); ?>