<?php

/**  
* Logging class:  
* - contains lfile, lopen and lwrite methods  
* - lfile sets path and name of log file  
* - lwrite will write message to the log file  
* - first call of the lwrite will open log file implicitly  
* - message is written with the following format: hh:mm:ss (script name) message  
*/

if(!defined('DS')){
	define('DS',DIRECTORY_SEPARATOR);
}
// use a local version of ABSPATH to avoid conflicts with installed application
if (defined('ABSPATH')) {
	#define('MYABSPATH', ABSPATH);
}
if (!defined('MYABSPATH')) {
	$logpath = get_document_path();
	if (!empty($logpath)) {
		define('MYABSPATH', $logpath);
		##define('MYABSPATH', dirname(__FILE__) );
	}
}

if (!class_exists("Logging")) {
	class Logging{     
		// define default log file     
		private $log_file =  'logfile.log';     
		// define file pointer     
		private $fp = null;   
	
		private $logging_enabled = true;
	
		// set log file (path and name)     
	
		public function lfile($path) {         
			$this->log_file = $path;     
			echo $path;
		}     
	
		// write message to the log file     
	
		public function lwrite($message){    
			// is logging enabled? 
			if (!$this->logging_enabled) {
				return false;
			}



			// if file pointer doesn't exist, then open log file         
			if (!$this->fp) $this->lopen();     
				// define script name         
				$script_name = pathinfo($_SERVER['PHP_SELF'], PATHINFO_FILENAME);         
				// define current time         
				$time = date('H:i:s');         
				// write current time, script name and message to the log file         
				fwrite($this->fp, "$time ($script_name) $message\n");     
		}     
	
		// open log file     
		private function lopen(){         
			// define log file path and name         
			$lfile = $this->log_file;         
			// define the current date (it will be appended to the log file name)     
			date_default_timezone_set("Europe/London");
			$today = date('Y-m-d');         
			// open log file for writing only; place the file pointer at the end of the file         
			// if the file does not exist, attempt to create it         
			$this->fp = fopen(MYABSPATH . DS . $lfile . '_' . $today, 'a') or exit("Can't open $lfile!");     
		} 
	}
} # not logging exists


if (!function_exists("logtext")) {
	function logtext($text='') {

#print_r("logging");

		$log = new Logging(); 

		ob_start();
		print_r($text);
		$msg = ob_get_contents();
		ob_end_clean();

		$log->lwrite($msg);
	}
}

if (!function_exists('tmpCustomError')) {
	function tmpCustomError($errno, $errstr, $errfile='', $errline='')
	 {
		if ($errno!=2048) {
			logtext("<b>Error:</b> [$errno] $errstr  : file=$errfile line=$errline<br />" );
			# echo "<b>Error:</b> [$errno] $errstr  : file=$errfile line=$errline<br />";
			#	die();
		}

		return false;
	}
}


?>