<?php

//###########################  P L U G I N    U P D A T E R   S E C T I O N  ##########################################################
/*
// TEMP: Enable update check on every request. Normally you don't need this! This is for testing only!
// NOTE: The 
//	if (empty($checked_data->checked))
//		return $checked_data; 
// lines will need to be commented in the check_for_plugin_update function as well.

set_site_transient('update_plugins', null);     // !!!!!!!!!!!!!!!!!!!!!!!

// TEMP: Show which variables are being requested when query plugin API
add_filter('plugins_api_result', 'aaa_result', 10, 3);
function aaa_result($res, $action, $args) {
#	print_r($res);
	return $res;
}
// NOTE: All variables and functions will need to be prefixed properly to allow multiple plugins to be updated
*/

$api_url = 'http://www.nufocus.co.uk/plugins/api/';
$plugin_slug = basename(dirname(__FILE__));

if (!class_exists("nufUpdaterClass")) {
	class nufUpdaterClass {
		var $api_url = 'http://www.nufocus.co.uk/plugins/api/';
		var $plugin_slug = '';

		function __construct( $basename='' ) {
			$this->plugin_slug = $basename; // basename(dirname(__FILE__));
			add_filter('pre_set_site_transient_update_plugins', array($this, 'check_for_plugin_update') );
			// Take over the Plugin info screen
			add_filter('plugins_api', array($this, 'plugin_api_call'), 10, 3);

		}
		function check_for_plugin_update($checked_data) {
			global $wp_version;

			$start = microtime(true);
			$plugin_slug = $this->plugin_slug;
			$api_url = $this->api_url;
			
			if (empty($checked_data->checked))
				return $checked_data;


			if (empty($checked_data->response[$plugin_slug .'/'. $plugin_slug .'.php'])) {
				// only do the remote checks if there entry is currently empty

				$args = array(
					'slug' => $plugin_slug,
					'version' => $checked_data->checked[$plugin_slug .'/'. $plugin_slug .'.php'],
				);

				$request_string = array(
					'body' => array(
						'action' => 'basic_check', 
						'request' => serialize($args),
						'api-key' => md5(get_bloginfo('url'))
					),
					'user-agent' => 'WordPress/' . $wp_version . '; ' . get_bloginfo('url')
				);
	

				// Start checking for an update
				$raw_response = wp_remote_post($api_url, $request_string);
				#print_r($raw_response);
	
				if (!is_wp_error($raw_response) && ($raw_response['response']['code'] == 200))
					$response = unserialize($raw_response['body']);

				if (is_object($response) && !empty($response)) // Feed the update data into WP updater
					$checked_data->response[$plugin_slug .'/'. $plugin_slug .'.php'] = $response;


					$endtime = microtime(true);
					#echo "<br>time=" . (($endtime-$start) * 1000);

					$GLOBALS['nufupdater'][$plugin_slug .'/'. $plugin_slug .'.php'] = (($endtime-$start) * 1000) . 'ms';
					#print_r($checked_data);
			}

			return $checked_data;

		}
	
		function plugin_api_call($def, $action, $args) {
			global $wp_version;
			#print_r($args);
	
			$plugin_slug = $this->plugin_slug;
			$api_url = $this->api_url;

			if (!isset($args->slug) || ($args->slug != $plugin_slug))
				return $def;
	

			// Get the current version
			$plugin_info = get_site_transient('update_plugins');
			$current_version = $plugin_info->checked[$plugin_slug .'/'. $plugin_slug .'.php'];
			$args->version = $current_version;
	
			$request_string = array(
				'body' => array(
					'action' => $action, 
					'request' => serialize($args),
					'api-key' => md5(get_bloginfo('url'))
				),
				'user-agent' => 'WordPress/' . $wp_version . '; ' . get_bloginfo('url')
			);
	

			$request = wp_remote_post($api_url, $request_string);
		
			if (is_wp_error($request)) {
				$res = new WP_Error('plugins_api_failed', __('An Unexpected HTTP Error occurred during the API request.</p> <p><a href="?" onclick="document.location.reload(); return false;">Try again</a>'), $request->get_error_message());
			} else {
				$res = unserialize($request['body']);
					if ($res === false)
					$res = new WP_Error('plugins_api_failed', __('An unknown error occurred'), $request['body']);
			}
			return $res;
		}

	} # end of nufUpdaterClass
}


${basename(dirname(__FILE__)).'_updater'} = new nufUpdaterClass($plugin_slug);  // uses a slug specific name even though class is used elsewhere


//########################### E N D   P L U G I N    U P D A T E R   S E C T I O N  ##########################################################

?>